#!/bin/bash

module load anaconda3/2023.09-0

source activate AmberTools24

#Create prmtop and rst7 files
cat <<EOF > tleap.in
verbosity 2

source leaprc.protein.ff14SB

loadoff solvents.lib
loadamberparams frcmod.pol3

set default DIPOLE_DAMP_FACTOR 2.4410

set default ipol 4

WAT = PL3
HOH = PL3

water = loadpdb water.pdb

check water

saveAmberParmPol water water.prmtop water.rst7

quit
EOF

tleap -I $(pwd) -f tleap.in

#clean up temporary files
rm tleap.in 

echo "**************************************************************************************"
echo "* Please check if all atom types have been correctly recognized in ${name}.prmtop.   *"
echo "* It might be necessary to replace -1 in ATOMIC_NUMBERS by the correct atomic number *"
echo "* for those atoms that could not be assigned.                                        *"
echo "**************************************************************************************"
