#!/usr/bin/env bash
AMBERHOME=/apps/amber24                # Define AMBERHOME variable
source $AMBERHOME/amber.sh             # Initialize AMBER environment
                                       
mpiengine="mpirun -np 4 $AMBERHOME/bin/pmemd.MPI"     # Define MD engine
cudaengine=$AMBERHOME/bin/pmemd.cuda   # Define MD engine

PRMTOP=complex_solv.prmtop   # Define topology/parameter file
INPCRD=opted.rst   # Define coordinate file

${cudaengine} -O -i relax.in -o relax.out -p ${PRMTOP} -c ${INPCRD} -r relax.rst -x relax.crd  # relax
${cudaengine} -O -i ti.in -o ti01.out -p ${PRMTOP} -c relax.rst -r ti01.rst -x ti01.crd  # ti

