#!/bin/bash


echo "Started Equilibration on `date` "
do_cuda="pmemd.cuda" 

prmtop="../complex.HMR.gas19.prmtop"
coords="../complex.gas19" 

MDINPUTS=(01.min 02.equil 10.prod 11.prod)

for input in ${MDINPUTS[@]}; do

 $do_cuda -O -i ${input}.mdin -o ${input}.mdout -p $prmtop -c ${coords}.rst7 -ref ${coords}.rst7 -x ${input}.trj -inf ${input}.info -r ${input}.rst7
 coords=$input
done 

echo "Finished Equilibration on `date` "
