#!/bin/bash 
source /home/soft/amber14/amber.sh

for num in 29 30 36 37 38 39 45 46 47 60 63 64 71 72 75 80 82 83 85 87 88 89; do 

cd /home/hbaldoni/DINAMICAS/CRUZAINA/COMPLEJO/MS${num}

export topo=./cmpx_MS${num}.top
export inicoor=./cmpx_MS${num}.crd
export EXE=/home/soft/amber14/bin/pmemd.cuda_SPFP

#=== MINIMIZA ================================

$EXE -O -i min_1.in -o min_1_MS${num}.out -p $topo -c $inicoor -ref $inicoor -r min_1_MS${num}.rst

$EXE -O -i min_2.in -o min_2_MS${num}.out -p $topo -c min_1_MS${num}.rst -ref min_1_MS${num}.rst -r min_2_MS${num}.rst

$EXE -O -i min_3.in -o min_3_MS${num}.out -p $topo -c min_2_MS${num}.rst -ref min_2_MS${num}.rst -r min_3_MS${num}.rst

$EXE -O -i min_4.in -o min_4_MS${num}.out -p $topo -c min_3_MS${num}.rst -ref min_3_MS${num}.rst -r min_4_MS${num}.rst


#==== EQUILIBRA ============================================

export coor=./min_4_MS${num}.rst

$EXE -O -i nvt.in -o nvt_MS${num}.out -p $topo -c $coor -ref $coor -r nvt_MS${num}.rst -x nvt_MS${num}.trj -e nvt_MS${num}.ene -inf infomd_nvt_MS${num}

$EXE -O -i npt.in -o npt_MS${num}.out -p $topo -c nvt_MS${num}.rst -ref nvt_MS${num}.rst -r npt_MS${num}.rst -x npt_MS${num}.trj -e npt_MS${num}.ene -inf infomd_npt_MS${num}

#====================================

mail -s " MS${num} Finalizado" "hbaldoni@unsl.edu.ar" < ../nohup.out

cd /home/hbaldoni/DINAMICAS/CRUZAINA/COMPLEJO

date

done




