#!/usr/bin/env python

# Test the imports
import sys
from spam import *
from optparse import OptionParser

optionlist = []

parser = OptionParser()

parser.add_option('--test-checkprogs', dest='checkprogs', default=False,
                  action='store_true', help='Test checkprogs.py')
parser.add_option('--test-traj', dest='traj', default=False,
                  action='store_true', help='Test traj.py')
parser.add_option('--test-nampdb', dest='nampdb', default=False,
                  action='store_true', help='Test nampdb.py')
parser.add_option('--test-dx', dest='dx', default=False, action='store_true',
                  help='Test dx.py')
parser.add_option('--test-xyzpeaks', dest='xyzpeaks', default=False,
                  action='store_true', help='Test xyzpeaks.py')
parser.add_option('--test-namdcalc', dest='namdcalc', default=False,
                  action='store_true', help='Test namdcalc.py')
parser.add_option('--test-spaminfo', dest='spaminfo', default=False,
                  action='store_true', help='Test spaminfo.py')
parser.add_option('--test-spamstats', dest='spamstats', default=False,
                  action='store_true', help='Test spamstats.py')
parser.add_option('--test-progressbar', dest='progressbar', default=False,
                  action='store_true', help='Test progressbar.py')

option_list = [str(opt) for opt in parser.option_list]

# Strip out all arguments that do *not* belong to this top-level script
if len(sys.argv) >= 2:
   args = [sys.argv[0]] + [arg for arg in sys.argv if arg in option_list]

if len(args) == 1:
   parser.print_help()
   sys.exit(0)

opt, arg = parser.parse_args(args=args)

# Load the args to pass to the test suite (which is basically the program name)
args = [arg for arg in sys.argv[1:] if arg not in option_list]

# Add the help back in if it was there
if '--help' in sys.argv or '-h' in sys.argv:
   args += ['--help']

# Make sure we test only 1 at a time
if sum([opt.checkprogs, opt.traj, opt.nampdb, opt.dx, opt.xyzpeaks,
        opt.namdcalc, opt.spaminfo, opt.spamstats, opt.progressbar]) != 1:
   print 'Pick 1 and only 1 item to test!'
   parser.print_help()
   sys.exit(1)

# Pick our test...
if opt.checkprogs:
   print 'Testing spam/checkprogs.py\n'
   checkprogs.test(args)

if opt.traj:
   print 'Testing spam/traj.py\n'
   traj.test(args)

if opt.nampdb:
   print 'Testing spam/nampdb.py\n'
   namdpdb.test(args)

if opt.dx:
   print 'Testing spam/dx.py\n'
   dx.test(args)

if opt.xyzpeaks:
   print 'Testing spam/xyzpeaks.py\n'
   xyzpeaks.test(args)

if opt.namdcalc:
   print 'Testing spam/namdcalc.py\n'
   namdcalc.test(args)

if opt.spaminfo:
   print 'Testing spam/spaminfo.py\n'
   spaminfo.test(args)

if opt.spamstats:
   print 'Testing spam/spamstats.py\n'
   spamstats.test(args)

if opt.progressbar:
   print 'Testing spam/progressbar.py\n'
   progressbar.test(args)

