[root@RX350s7ambertest amber12]# cat config.h
#  Amber configuration file, created with: ./configure -mpi -cuda intel

###############################################################################

# (1)  Location of the installation

BASEDIR=/root/amber/amber12
BINDIR=/root/amber/amber12/bin
LIBDIR=/root/amber/amber12/lib
INCDIR=/root/amber/amber12/include
DATDIR=/root/amber/amber12/dat
LOGDIR=/root/amber/amber12/logs

###############################################################################


#  (2) If you want to search additional libraries by default, add them
#      to the FLIBS variable here.  (External libraries can also be linked into
#      NAB programs simply by including them on the command line; libraries
#      included in FLIBS are always searched.)

FLIBS=  -lsff_mpi -lpbsa   -larpack  $(BASEDIR)/lib/libnetcdf.a -Wl,--start-group /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_intel_lp64.a /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_sequential.a /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_core.a -Wl,--end-group -lpthread -L/opt/intel/composer_xe_2013.1.117/lib/intel64 -lifport -lifcore -lsvml
FLIBS_PTRAJ= -larpack  -Wl,--start-group /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_intel_lp64.a /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_sequential.a /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_core.a -Wl,--end-group -lpthread -L/opt/intel/composer_xe_2013.1.117/lib/intel64 -lifport -lifcore -lsvml
FLIBSF= -larpack  -Wl,--start-group /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_intel_lp64.a /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_sequential.a /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_core.a -Wl,--end-group -lpthread  -lsvml
FLIBS_FFTW3=
###############################################################################

#  (3)  Modify any of the following if you need to change, e.g. to use gcc
#        rather than cc, etc.

SHELL=/bin/sh
INSTALLTYPE=cuda_parallel
BUILDAMBER=amber

#  Set the C compiler, etc.

#  The configure script should be fine, but if you need to hand-edit,
#  here is some info:

#   Example:  CC-->gcc; LEX-->flex; YACC-->yacc (built in byacc)
#     Note: If your lexer is "really" flex, you need to set
#     LEX=flex below.  For example, on some distributions,
#     /usr/bin/lex is really just a pointer to /usr/bin/flex,
#     so LEX=flex is necessary.  In general, gcc seems to need flex.

#   The compiler flags CFLAGS and CXXFLAGS should always be used.
#   By contrast, *OPTFLAGS and *NOOPTFLAGS will only be used with
#   certain files, and usually at compile-time but not link-time.
#   Where *OPTFLAGS and *NOOPTFLAGS are requested (in Makefiles,
#   makedepend and depend), they should come before CFLAGS or
#   CXXFLAGS; this allows the user to override *OPTFLAGS and
#   *NOOPTFLAGS using the BUILDFLAGS variable.

#   AMBERBUILDFLAGS provides a hook into all stages of the build process.
#   It can be used to build debug versions, invoke special features, etc.
#   Example:  make AMBERBUILDFLAGS='-O0 -g' sander
#
CC=mpicc
CFLAGS= -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE -DBINTRAJ -DHASGZ -DHASBZ2 -DMPI  $(CUSTOMBUILDFLAGS) -I/opt/intel/composer_xe_2013.1.117/mkl/include $(AMBERBUILDFLAGS)
CNOOPTFLAGS=
COPTFLAGS=-ip -O3 -xHost
AMBERCFLAGS= $(AMBERBUILDFLAGS)

CXX=icpc
CPLUSPLUS=icpc
CXXFLAGS= -DMPI  $(CUSTOMBUILDFLAGS) $(AMBERBUILDFLAGS)
CXXNOOPTFLAGS=
CXXOPTFLAGS=-O3
AMBERCXXFLAGS= $(AMBERBUILDFLAGS)

NABFLAGS= $(AMBERBUILDFLAGS)
PBSAFLAG= $(AMBERBUILDFLAGS)

LDFLAGS=-shared-intel  $(CUSTOMBUILDFLAGS) $(AMBERBUILDFLAGS)
AMBERLDFLAGS=$(AMBERBUILDFLAGS)

LEX=   flex
YACC=  $(BINDIR)/yacc
AR=    ar rv
M4=    m4
RANLIB=ranlib

#  Set the C-preprocessor.  Code for a small preprocessor is in
#    ucpp-1.3;  it gets installed as $(BINDIR)/ucpp;

CPP=ucpp -l

#  These variables control whether we will use compiled versions of BLAS
#  and LAPACK (which are generally slower), or whether those libraries are
#  already available (presumably in an optimized form).

LAPACK=skip
BLAS=skip
F2C=skip

#  These variables determine whether builtin versions of certain components
#  can be used, or whether we need to compile our own versions.

UCPP=install
C9XCOMPLEX=skip

#  For Windows/cygwin, set SFX to ".exe"; for Unix/Linux leave it empty:
#  Set OBJSFX to ".obj" instead of ".o" on Windows:

SFX=
OSFX=.o
MV=mv
RM=rm
CP=cp

#  Information about Fortran compilation:

FC=mpif90
FFLAGS=  $(LOCALFLAGS) $(CUSTOMBUILDFLAGS) -I$(INCDIR) $(NETCDFINC) -I/opt/intel/composer_xe_2013.1.117/mkl/include $(AMBERBUILDFLAGS)
FNOOPTFLAGS= -O0
FOPTFLAGS= -ip -O3 -xHost
AMBERFFLAGS=$(AMBERBUILDFLAGS)
FREEFORMAT_FLAG= -FR
LM=-lm
FPP=cpp -traditional -P
FPPFLAGS= -DMKL -DBINTRAJ -DMPI  $(CUSTOMBUILDFLAGS) $(AMBERBUILDFLAGS)
AMBERFPPFLAGS=$(AMBERBUILDFLAGS)
FCREAL8=

XHOME= /usr
XLIBS= -L/usr/lib64 -L/usr/lib
MAKE_XLEAP=install_xleap

NETCDF=$(BASEDIR)/include/netcdf.mod
NETCDFLIB=$(BASEDIR)/lib/libnetcdf.a
NETCDFINC=-I$(BASEDIR)/include
FFTWLIB=

ZLIB=-lz
BZLIB=-lbz2

HASFC=yes
MTKPP=
XBLAS=
FFTW3=
MDGX=no

COMPILER=intel
MKL=/opt/intel/composer_xe_2013.1.117/mkl
MKL_PROCESSOR=intel64

#CUDA Specific build flags
NVCC=/usr/local/cuda-5.0/bin/nvcc -gencode arch=compute_13,code=sm_13 -gencode arch=compute_20,code=sm_20 -gencode arch=compute_30,code=sm_30 -gencode arch=compute_35,code=sm_35 -use_fast_math -O3
PMEMD_CU_INCLUDES=-I$(CUDA_HOME)/include -IB40C -IB40C/KernelCommon -I/usr/local/cuda-5.0/include -I/usr/local/cuda-5.0/include -I/usr/local/include
PMEMD_CU_LIBS=./cuda/cuda.a -L$(CUDA_HOME)/lib64 -L$(CUDA_HOME)/lib -lcurand -lcufft -lcudart -L/usr/lib64 -lstdc++
PMEMD_CU_DEFINES=-DCUDA -DMPI -DMPICH_IGNORE_CXX_SEEK -Duse_SPFP

#PMEMD Specific build flags
PMEMD_F90=mpif90 -DMPI   -DMKL -DBINTRAJ -DDIRFRC_EFS -DDIRFRC_COMTRANS -DDIRFRC_NOVEC -DFFTLOADBAL_2PROC -DPUBFFT
PMEMD_FOPTFLAGS=-ip -O3 -no-prec-div -xHost $(AMBERBUILDFLAGS)
PMEMD_CC=mpicc
PMEMD_COPTFLAGS=-ip -O3 -no-prec-div -xHost -DMPICH_IGNORE_CXX_SEEK -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE -DBINTRAJ -DMPI  $(AMBERBUILDFLAGS)
PMEMD_FLIBSF=-Wl,--start-group /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_intel_lp64.a /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_sequential.a /opt/intel/composer_xe_2013.1.117/mkl/lib/intel64/libmkl_core.a -Wl,--end-group -lpthread
PMEMD_LD= mpif90  $(AMBERBUILDFLAGS)
LDOUT= -o

#for NAB:
MPI=mpi

#1D-RISM
RISM=no

#3D-RISM NAB
RISMSFF=
SFF_RISM_INTERFACE=
TESTRISMSFF=

#3D-RISM SANDER
RISMSANDER=
SANDER_RISM_INTERFACE=
FLIBS_RISMSANDER=
TESTRISMSANDER=

#PUPIL
PUPILLIBS=-lrt -lm -lc -L${PUPIL_PATH}/lib -lPUPIL -lPUPILBlind

#Python interpreter we are using
PYTHON=/usr/bin/python2.6
[root@RX350s7ambertest amber12]#