#!/bin/bash

# gpu-info
# Written by Jodi Hadden, University of Georgia, 2011. Updated 2013.
# List GPUs by deviceQuery ID with corresponding temperature and utilization from NVIDIA-SMI 
# Works for NVIDIA-SMI 3.295.41 Driver Version: 295.41 for Tesla series cards

# Check for deviceQuery
if ! type deviceQuery >/dev/null
then
        echo "Please add the location of deviceQuery to your PATH!"
        exit
fi

# Make all GPUs temporarily visible
num_gpus=`nvidia-smi -a | grep "Attached GPUs" | cut -b35`
export CUDA_VISIBLE_DEVICES=`seq -s , 0 $num_gpus`

# Obtain PCI bus IDs that correspond to deviceQuery IDs, converting decimal to hex for use with NVIDIA-SMI
pci_bus_array=( $( ( echo "obase=16" ; deviceQuery -noprompt | grep "Device PCI Bus ID / PCI location ID" | cut -b50-60 | sed "s/\/ 0//" ) | bc ) )
rm -f deviceQuery.txt SdkMasterLog.csv

# Print a neat table
echo "==================================================="
echo -e "Device\tModel\t\tTemperature\tUtilization"
echo "==================================================="

# For each deviceQuery ID, use corresponding PCI bus ID to print temperature and utilization from NVIDIA-SMI 
gpu_id=0
while [ $gpu_id -lt ${#pci_bus_array[*]} ]
do

        # Get and print information from NVIDIA-SMI
        model=`nvidia-smi -a -i 0:${pci_bus_array[$gpu_id]}:0 | grep "Product Name" | cut -b35-45`
        temperature=`nvidia-smi -a -i 0:${pci_bus_array[$gpu_id]}:0 | grep -A1 "Temperature" | grep "Gpu" | cut -b35-45`
        utilization=`nvidia-smi -a -i 0:${pci_bus_array[$gpu_id]}:0 | grep -A1 "Utilization" | grep "Gpu" | cut -b35-45`

        echo -e "$gpu_id\t$model\t$temperature\t\t$utilization"

        let gpu_id=$gpu_id+1

done

echo "==================================================="
