#!/bin/bash -l


#* In order to run CUDA applications, the CUDA module must be
#loaded and the entries in /dev created. This may be achieved
#by initializing X Windows, or by creating a script to load the
#kernel module and create the entries.



#An example script (to be run at boot time):



/sbin/modprobe nvidia

if [ "$?" -eq 0 ]; then
  # Count the number of NVIDIA controllers found.
  NVDEVS=`lspci | grep -i NVIDIA`
  N3D=`echo "$NVDEVS" | grep "3D controller" | wc -l`
  NVGA=`echo "$NVDEVS" | grep "VGA compatible controller" | wc -l`

  N=`expr $N3D + $NVGA - 1`
  for i in `seq 0 $N`; do
    mknod -m 666 /dev/nvidia$i c 195 $i
  done

  mknod -m 666 /dev/nvidiactl c 195 255

else
  exit 1
fi

#-pm,  --persistence-mode=   Set persistence mode: 0/DISABLED, 1/ENABLED
nvidia-smi -pm 1 

#    -c,   --compute-mode=       Set MODE for compute applications: 0/DEFAULT, 1/EXCLUSIVE_THREAD,   2/PROHIBITED, 3/EXCLUSIVE_PROCESS
nvidia-smi -c 3
