#!/bin/bash

# gpu-free
# Written by Jodi Hadden, University of Georgia, 2011. Updated 2013.
# Print free GPU deviceQuery IDs to export as visible with CUDA_VISIBLE_DEVICES
# Works for NVIDIA-SMI 3.295.41 Driver Version: 295.41 for Tesla series cards

# Check for deviceQuery
if ! type deviceQuery >/dev/null
then
        echo "Please add the location of deviceQuery to your PATH!"
        exit
fi

# Make all GPUs temporarily visible
num_gpus=`nvidia-smi -a | grep "Attached GPUs" | cut -b35`
export CUDA_VISIBLE_DEVICES=`seq -s , 0 $num_gpus`

# Obtain PCI bus IDs that correspond to deviceQuery IDs, converting decimal to hex for use with NVIDIA-SMI
pci_bus_array=( $( ( echo "obase=16" ; deviceQuery -noprompt | grep "Device PCI Bus ID / PCI location ID" | cut -b50-60 | sed "s/\/ 0//" ) | bc ) )
rm -f deviceQuery.txt SdkMasterLog.csv

# For each PCI bus ID, check to see if that GPU is being utilized 
gpu_id=0
while [ $gpu_id -lt ${#pci_bus_array[*]} ]
do

        # Get utilization from NVIDIA-SMI
        utilization=`nvidia-smi -a -i 0:${pci_bus_array[$gpu_id]}:0 | grep -A1 "Utilization" | grep "Gpu" | cut -b35-36`

        # If a GPU is not being utilized, add its deviceQuery ID to the free GPU array
        # Note: GPUs can show 1% utilization if NVIDIA-SMI is running in the background, so used -le 1 instead of -eq 0 here
        if [ $utilization -le 1 ]
        then
                free_gpu_array[$gpu_id]=$gpu_id
        fi

        let gpu_id=$gpu_id+1

done

# Print free GPUs to export as visible 
free_gpus=`echo ${free_gpu_array[*]} | sed "s/ /,/g"`
echo $free_gpus
