#!/bin/bash
#
# [4-X-2012]
#
#*******************************************************************************
#
#   Script for running Thermodynamic Integration Calculations with AMBER
#
#*******************************************************************************

cd ${PWD}

pre0='glbWAT'
pre1='glbWAT'
mask0chg=':GLB'
mask1chg=''
mask0sc=''
mask1sc=''
mask0nSk=':GLB'
mask1nSk=':GLB'
runFile='TI2.C'

echo " "

for X in 01 05 10 20 30 40 50 60 70 80 90 95 99

do

  echo " -. Current lambda value: 0.${X} "
  echo -n "      Starting process "
  date 


  if [ ! -d lam0.${X} ]
  then

    echo "       Creating folder lam0.${X} "
    mkdir lam0.${X}

    echo "       Copying crd and top files into directory lam0.${X} "
    cp ${pre0}.crd ${pre0}.top lam0.${X}
    cp ${pre1}.crd ${pre1}.top lam0.${X}

    echo "       Moving to directory lam0.${X} "
    cd lam0.${X}

  else

    echo "       Moving to directory lam0.${X} "
    cd lam0.${X}

  fi


  echo "        Creating group files for multisander "

  cat << EOF > groupStp3_l${X}
-O -i stp3V0_l${X}.in -o ${pre0}_stp3V0_l${X}.out -p ${pre0}.top -c ${pre0}_stp0bV0_l${X}.rst -r ${pre0}_stp3V0_l${X}.rst -x ${pre0}_stp3V0_l${X}.trj -e ${pre0}_stp3V0_l${X}.erg -inf ${pre0}_stp3V0_l${X}.inf
-O -i stp3V1_l${X}.in -o ${pre1}_stp3V1_l${X}.out -p ${pre1}.top -c ${pre1}_stp0bV1_l${X}.rst -r ${pre1}_stp3V1_l${X}.rst -x ${pre1}_stp3V1_l${X}.trj -e ${pre1}_stp3V1_l${X}.erg -inf ${pre1}_stp3V1_l${X}.inf
EOF

  cat << EOF > groupStp4_l${X}
-O -i stp4V0_l${X}.in -o ${pre0}_stp4V0_l${X}.out -p ${pre0}.top -c ${pre0}_stp3V0_l${X}.rst  -r ${pre0}_stp4V0_l${X}.rst -x ${pre0}_stp4V0_l${X}.trj -e ${pre0}_stp4V0_l${X}.erg -inf ${pre0}_stp4V0_l${X}.inf
-O -i stp4V1_l${X}.in -o ${pre1}_stp4V1_l${X}.out -p ${pre1}.top -c ${pre1}_stp3V1_l${X}.rst  -r ${pre1}_stp4V1_l${X}.rst -x ${pre1}_stp4V1_l${X}.trj -e ${pre1}_stp4V1_l${X}.erg -inf ${pre1}_stp4V1_l${X}.inf
EOF


  echo "        Step 3: Creating input files for NVT equilibration "

  var2=${RANDOM}  

  cat << EOF > stp3V0_l${X}.in
Step 3. NVT TI Thermal Equilibration in Water. SHAKE in solvent BUT not in solute
 &cntrl
   imin=0,         nmropt=0,
   ntx=1,          irest=0,     ntrx=1,
   ntxo=1,         ntpr=1000,   ntwr=1000,
   iwrap=0,
   ntwx=1000,      ntwv=0,      ntwe=1000,
   ntf=2,          ntc=2,       ntb=1,
   ntp=0,
   igb=0,          nsnb=25,     cut=9.0,
   nstlim=100000,  nscm=1000,   nrespa=1,
   t=0.0,          dt=0.001,
   vrand=0,        vlimit=20.0,
   ig=${var2},     ntt=3,       gamma_ln=2.0,
   temp0=298.0,    tempi=0.0,   tautp=0.5,
   tol=0.00001,
   icfe=1,         clambda = 0.${X},
EOF

  cp stp3V0_l${X}.in stp3V1_l${X}.in

  cat << EOF >> stp3V0_l${X}.in
   ifsc=0,
   crgmask='${mask0chg}',
   noshakemask='${mask0nSk}',
 / 
EOF

  cat << EOF >> stp3V1_l${X}.in
   ifsc=0,
   crgmask='${mask1chg}',
   noshakemask='${mask1nSk}',
 /
EOF


  echo "        Step 4: Creating input files for NVT production-sampling "

  var3=${RANDOM}

  cat << EOF > stp4V0_l${X}.in
Step 4. NVT TI Production-sampling in Water. SHAKE in solvent BUT not in solute
 &cntrl
   imin=0,         nmropt=0,
   ntx=1,          irest=0,     ntrx=1,
   ntxo=1,         ntpr=1000,   ntwr=1000,
   iwrap=0,
   ntwx=1000,      ntwv=0,      ntwe=1000,
   ntf=2,          ntc=2,       ntb=1,
   ntp=0,
   igb=0,          nsnb=25,     cut=9.0,
   nstlim=5000000, nscm=1000,   nrespa=1,
   t=0.0,          dt=0.001,
   vrand=0,        vlimit=20.0,
   ig=${var3},     ntt=3,       gamma_ln=2.0,
   temp0=298.0,    tempi=0.0,   tautp=0.5,
   tol=0.00001,
   icfe=1,         clambda = 0.${X},
EOF

  cp stp4V0_l${X}.in stp4V1_l${X}.in

  cat << EOF >> stp4V0_l${X}.in
   ifsc=0,
   crgmask='${mask0chg}',
   noshakemask='${mask0nSk}',
 /
EOF

  cat << EOF >> stp4V1_l${X}.in
   ifsc=0,
   crgmask='${mask1chg}',
   noshakemask='${mask1nSk}',
 /
EOF

  echo "       Creating   job file ${runFile}${X} "
  cat << EOF > ${runFile}${X}
##  SGE Job Stuff
#$ -cwd
#$ -V
#$ -l 's_rt=24:00:00'
#$ -pe smp.pe 8

mpiexec -n \$NSLOTS $AMBERHOME/exe/sander.MPI -ng 2 -groupfile groupStp3_l${X}
mpiexec -n \$NSLOTS $AMBERHOME/exe/sander.MPI -ng 2 -groupfile groupStp4_l${X}

EOF

  echo "       Submitting job file ${runFile}${X} "
  qsub ${runFile}${X}
 
  echo "       Moving to parent directory "
  cd ../

  echo "      Done "
  echo " "

 
done

echo " Normal termination "
echo " "

exit 0

