#!/usr/bin/perl -w
#### This perlscript takes in the animated output file (anim.pdb) from PCZdump and extracts two models whose coordinates are furthest apart. 	
#### (Model 6 and Model 16 are defaults from PCZdump). It then draws arrows between the two corresponding coordinates from the models.


use strict;

my($i) = 0;
my($ii) = 0;
my($refs) = 0;
my(@newarray6);
my(@newarray16);

my($aha) = 0;
my(@aha);
my($output_vmd) = "porcupine.vmd";					######### EDIT: this is the name of the output vmd file

if ($#ARGV != 0){ print "\n\n Usage: ./porcupine.pl <name of the output anim.pdb file from pczdump>\n\n\n"; exit;}

my($input_file) = $ARGV[0];

my ($FILE) = $input_file; 						
open(INFILE, $FILE);
open(COORD_A, ">tmp6");							########### starting coordinates 
open(COORD_B, ">tmp16");       						########### end coordinates. 		these files will be deleted in the end


my($output_pdb) = "start_6.pdb";					########### EDIT: pdb to be used as input file in vmd


open(COORD_X, ">$output_pdb");   



my(@refs) = <INFILE>;

while (@refs){

	if (($refs[$ii]) =~ /^MODEL      6/){
	
		 		
		my($linea) = ($ii+1); 
				
		print (COORD_A "MODEL 6\n"); 				##### reverse this order if you wish to have arrows from 16 to 6
		print (COORD_X "MODEL 6\n"); 				##### output 6 now....but change to 16 if you wish to reverse things around
				
			
			while ($refs[$linea] =~ /^ATOM/){
		
				my($xyz) = substr($refs[$linea], 30,23);
				
				@newarray6 = $xyz;
				
				print (COORD_A "@newarray6\n");
				
				print (COORD_X $refs[$linea]);
								
				$linea++;}
		
					if (($refs[$linea]) =~ /^TER|^END|^ENDMDL|^MODEL/){
			
						print (COORD_A "TER\n"); goto second; }
	}

	
	second: if (($refs[$i]) =~ /^MODEL     16/){
	
				
		my($linei) = ($i+1); 
				
		print (COORD_B "MODEL 16\n"); 
		
		
		
			while ($refs[$linei] =~ /^ATOM/){
		
				my($abc) = substr($refs[$linei], 30,23);
			
				@newarray16 = $abc;
				
				print (COORD_B "@newarray16\n");


			
				$linei++;}
		
					if (($refs[$linei]) =~ /^TER|^END|^ENDMDL|^MODEL/){
			
						print (COORD_B "TER\n"); goto third;}
						
						
		}

$i++;
$ii++;

}


third: open(COORD_A, "<tmp6");
open(COORD_B, "<tmp16");


my(@pdb6) = <COORD_A>;
my(@pdb16) = <COORD_B>;

open(COORD_OUT, ">$output_vmd");							


my ($ci) = 1;

		print (COORD_OUT "display projection   Orthographic\n");	   	####### orthographic projection.
		print (COORD_OUT "mol new $output_pdb type pdb\n");			####### the name of your pdb file (starting coordinates) goes in here
		print (COORD_OUT "graphics top color 1\n");		   		####### color of the arrows


while (@pdb6){

		
		chomp ($pdb6[$ci]);
		chomp ($pdb16[$ci]);
		
		
		my($modi) = "graphics top cone {$pdb6[$ci]} {$pdb16[$ci]} radius 0.350000 radius2 0.000000 resolution 10"; ##### this is the line to edit if you wish 
							    								   ##### change the resolution, thickness or even direction of arrows.
			
		if ($modi =~ /TER/) { system "rm -f tmp6 tmp16"; last;} 
		
		@aha = "$modi\n";

		print (COORD_OUT @aha);

		$ci++;	
		
		}
		
		print (COORD_OUT "mol delrep 0 top\n");			     	   	###### topology representation
		print (COORD_OUT "mol representation Tube 0.200000 6.000000\n");	###### tube representation
		print (COORD_OUT "mol color ColorID 8\n"); 		     	   	###### colour of the tube
		print (COORD_OUT "mol addrep top\n");			     	   	###### tube representation
		print (COORD_OUT "color Display {Background} white\n");	     	   	###### background colour...I like white

system("clear");
print "\n\n ALL DONE!!  Visualise in vmd using command: vmd -e porcupine.vmd";
print "\n\n Citation:\n";
print "\n Haider S, Parkinson GN, Neidle S.\n";
print " Molecular dynamics and principal components analysis of human telomeric quadruplex multimers.\n";
print " Biophys J. 2008 Jul;95(1):296-311.\n\n";
			
close(COORD_A);
close(COORD_B);
close(COORD_OUT);
close(COORD_X);



			
			
			
			
