#!/bin/bash


#pocet nodu ktere chci naloudovat do virtualniho stroje
NODES=1
#pocet procesoru, per nod
PPN=8
#celkovy pocet procesoru na kterych pobezi spustena uloha
CPUS=8

export EXE="/$AMBERHOME/exe/sander.MPI"

#nabootovani virtualniho multi CPU stroje
mpdboot -f ~/.mpd25.hosts -n $NODES


pre0='phen_w'
pre1='w'
mask0=':PHN'
mask1=''
IFSC=1;



for X in 1 2 3 4 5 6 7 75 8 85 9

do

cat << EOF > group_min_L${X}
-O -i mdin_min_v0_L${X} -o ${pre0}_min_v0_L${X}.out -p ${pre0}.prmtop -c ${pre0}.inpcrd -r ${pre0}_min_v0_L${X}.rst
-O -i mdin_min_v1_L${X} -o ${pre1}_min_v1_L${X}.out -p ${pre1}.prmtop -c ${pre1}.inpcrd -r ${pre1}_min_v1_L${X}.rst
EOF
cat << EOF > group_equi_L${X}
-O -i mdin_equi_v0_L${X} -o ${pre0}_equi_v0_L${X}.out -p ${pre0}.prmtop -c ${pre0}_min_v0_L${X}.rst -r ${pre0}_equi_v0_L${X}.rst
-O -i mdin_equi_v1_L${X} -o ${pre1}_equi_v1_L${X}.out -p ${pre1}.prmtop -c ${pre1}_min_v1_L${X}.rst -r ${pre1}_equi_v1_L${X}.rst
EOF
cat << EOF > group_prod_L${X}
-O -i mdin_prod_v0_L${X} -o ${pre0}_prod_v0_L${X}.out -p ${pre0}.prmtop -c ${pre0}_equi_v0_L${X}.rst -r ${pre0}_prod_v0_L${X}.rst -x ${pre0}_prod_v0_L${X}.crd
-O -i mdin_prod_v1_L${X} -o ${pre1}_prod_v1_L${X}.out -p ${pre1}.prmtop -c ${pre1}_equi_v1_L${X}.rst -r ${pre1}_prod_v1_L${X}.rst -x ${pre1}_prod_v1_L${X}.crd
EOF

cat << EOF > mdin_min_v0_L${X}
MINIMISATION
 &cntrl
  imin = 1,	ntx = 1,
  maxcyc=500,  ntmin=2,
  ntpr = 100,
  ntf = 1,      ntc = 2,
  ntb = 1,	cut = 9.0,
  icfe=1,	clambda = 0.${X},
EOF

cp mdin_min_v0_L${X} mdin_min_v1_L${X}

cat << EOF >> mdin_min_v0_L${X}
  ifsc=$IFSC,
  crgmask='${mask0}',
  scmask='${mask0}',
 &end
EOF
cat << EOF >> mdin_min_v1_L${X}
  ifsc=$IFSC,
  crgmask='${mask1}',
  scmask='${mask1}',
 &end
EOF

cat << EOF > mdin_equi_v0_L${X}
EQUILIBRATION
 &cntrl
  imin = 0,	ntx = 1,	irest = 0,
  ntpr = 1000,	ntwr = 10000,	ntwx = 0,
  ntf = 1,      ntc = 2,
  ntb = 2,	cut = 9.0,
  nstlim = 25000,	dt = 0.002,
  temp0 = 300.0,	ntt = 3,	gamma_ln = 5,
  ntp = 1,	pres0 = 1.0,	taup = 0.2,
  icfe=1,	clambda = 0.${X},
EOF

cp mdin_equi_v0_L${X} mdin_equi_v1_L${X}

cat << EOF >> mdin_equi_v0_L${X}
  ifsc=$IFSC,
  crgmask='${mask0}',
  scmask='${mask0}',
 &end
EOF
cat << EOF >> mdin_equi_v1_L${X}
  ifsc=$IFSC,
  crgmask='${mask1}',
  scmask='${mask1}',
 &end
EOF

cat << EOF > mdin_prod_v0_L${X}
PRODUCTION
 &cntrl
  imin = 0,	ntx = 5,	irest = 1,
  ntpr = 10000,	ntwr = 100000,	ntwx = 10000,
  ntf = 1,	ntc = 2,
  ntb = 2,	cut = 9.0,
  nstlim = 100000,	dt = 0.002,
  temp0 = 300.0,	ntt = 3,	gamma_ln = 2,
  ntp = 1,	pres0 = 1.0,	taup = 2.0,
  icfe=1,       clambda = 0.${X},
EOF

cp mdin_prod_v0_L${X} mdin_prod_v1_L${X}

cat << EOF >> mdin_prod_v0_L${X}
  ifsc=$IFSC,
  crgmask='${mask0}',
  scmask='${mask0}',
 &end
EOF
cat << EOF >> mdin_prod_v1_L${X}
  ifsc=$IFSC,
  crgmask='${mask1}',
  scmask='${mask1}',
 &end
EOF

CPUS=2
mpiexec -ppn $PPN -n $CPUS $EXE  -ng 2 -groupfile group_min_L${X}
CPUS=8
mpiexec -ppn $PPN -n $CPUS $EXE  -ng 2 -groupfile group_equi_L${X}
mpiexec -ppn $PPN -n $CPUS $EXE  -ng 2 -groupfile group_prod_L${X}


done

#uvolneni virtualniho stroje
mpdallexit


