#!/bin/bash

top=$1
crd=$2
cut=$3
ncpu=1
restraintmask=$5

echo -e "minimize water and hydrogens and all built atoms with environment
 &cntrl
  irest=0,ntx=1,
  imin=1,maxcyc=100,drms=0.0001,ntmin=2,
  ntc=2,ntf=2,
  cut=${cut},
  ntpr=100,
  ntr=1,restraint_wt=100.0,
  restraintmask='${restraintmask}' 
 /" > min.in
#mpirun -n $ncpu sander.MPI -O -i min.in -o min.out -p $top -c $crd -r min.rst -ref $crd
sander -O -i min.in -o min.out -p $top -c $crd -r min.rst -ref $crd
ambpdb -p $top < min.rst > min.rst.pdb
