#!/bin/bash

top=$1
crd=$2
cut=$3
resource=$4
xpu=$5
ig=$6


pmemd_cmd='notset'
if [ $resource == 'cpu' ]; then pmemd_cmd="mpirun -np $xpu pmemd"; fi
if [ $resource == 'gpu' ]; then pmemd_cmd="pmemd.cuda -gpu $xpu "; fi


echo -e "equilibrate water and hydrogens (NVT)
 &cntrl
  ig=${ig},
  irest=0,ntx=1,
  nstlim=1000,dt=0.002,
  temp0=300.0,ntt=1,tautp=1.0,
  ntc=2,ntf=2,
  cut=${cut},
  ntpr=500,ntwx=5,ntwv=0,ntwe=5,
  ntb=1,
  ntr=1
 /
Group 1
50.0
FIND
* * M *
* * S *
* * B *
* * 3 *
* * E *
SEARCH
RES 1 100000
END
END
" > eq1.in
${pmemd_cmd} -O -i eq1.in -o eq1.out -p $top -c min.rst -r eq1.rst -x eq1.netcdf -ref min.rst
#ambpdb -p $top < eq1.rst > eq1.rst.pdb

