#!/bin/bash 

echo -e "
source leaprc.ff99SBildn
loadoff znb.lib
#loadoff hin.lib
#loadoff hydroxide.lib
loadamberparams frcmod.zinc

rec = loadpdb rec.pdb
saveamberparm rec rec.top rec.crd

lig = loadpdb lig.pdb
saveamberparm lig lig.top lig.crd

com = combine{rec lig}
saveamberparm com com.top com.crd
savepdb com com.protonated.pdb 

wat = loadpdb wat.pdb

sys = combine{com wat}

# addions com Cl- 0
# addions com Na+ 0

solvateoct sys TIP3PBOX 10
saveamberparm sys com.TIP3PBOX.top com.TIP3PBOX.crd
savepdb sys com.TIP3PBOX.pdb

quit
" > createTOPs.leap
tleap -f createTOPs.leap

# cleanup
rm createTOPs.leap rec.crd lig.crd com.crd leap.log


