#!/bin/bash

top=$1
crd=$2
cut=$3
resource=$4
xpu=$5
nstlim=$6


pmemd_cmd='notset'
if [ $resource == 'cpu' ]; then pmemd_cmd="mpirun -np $xpu pmemd"; fi
if [ $resource == 'gpu' ]; then pmemd_cmd="pmemd.cuda -gpu $xpu "; fi


echo -e "equilibrate side-chains (NVT)
 &cntrl
  ig=0,
  irest=0,ntx=1,
  nstlim=${nstlim},dt=0.002,
  temp0=300.0,ntt=1,tautp=1.0,
  ntc=2,ntf=2,
  cut=${cut},
  ntpr=500,ntwx=5,ntwv=0,ntwe=5,
  ntb=1,
  ntr=1
 /
Group 1
50.0
FIND
* * M *
SEARCH
RES 1 100000
END
END
" > eq2.in
${pmemd_cmd} -O -i eq2.in -o eq2.out -p $top -c eq1.rst -r eq2.rst -x eq2.netcdf -ref eq1.rst
#ambpdb -p $top < eq2.rst > eq2.rst.pdb

