#!/bin/bash

if [ -d output ]
then
	rm -r output
fi
mkdir output
cd output

# I need this line as I only have access to AMBER 9,
# but can use rdparm from AmberTools.

#export AMBERHOME=~/software/amber10

$AMBERHOME/exe/rdparm ../input/waterbox.prmtop <<EOF
stripwater
yes
909
waterbox_minus_one.prmtop
quit
EOF

# Hack to swap equilibrium bond distances (line 1945 of prmtop)

sed "s/1.51360000E+00  9.57200000E-01/9.57200000E-01  1.51360000E+00/" waterbox_minus_one.prmtop > waterbox_minus_one_fixed.prmtop

# Now energy calculations

# I need this line as I only have access to AMBER 9,
# but can use rdparm from AmberTools.

#export AMBERHOME=/software/amber_v9.0

$AMBERHOME/exe/sander -O -i ../input/sander.in -o waterbox.out \
	-p ../input/waterbox.prmtop -c ../input/waterbox.inpcrd

$AMBERHOME/exe/sander -O -i ../input/sander.in -o waterbox_minus_one.out \
	-p waterbox_minus_one.prmtop -c ../input/waterbox_minus_one.inpcrd

$AMBERHOME/exe/sander -O -i ../input/sander.in -o waterbox_minus_one_fixed.out \
	-p waterbox_minus_one_fixed.prmtop -c ../input/waterbox_minus_one.inpcrd

