#==============================================================================
# AMBER Makefile configuration for compiler/architecture: sgi_altix
# Generated via command: ./configure -mpi sgi_altix
#
# Configuration script written mainly by Joe Krahn, Scott Brozell, and
# Dave Case, with contributions from lots of people.
#==============================================================================

#------------------------------------------------------------------------------
# Main AMBER source root directory
#------------------------------------------------------------------------------
AMBER_SRC=/disk1/chem/amber9/src

#------------------------------------------------------------------------------
# AMBERBUILDFLAGS provides a hook into the build process for installers;
# for example, to build debug versions of the amber programs
# make -e AMBERBUILDFLAGS="-DDEBUG -g"
#------------------------------------------------------------------------------
AMBERBUILDFLAGS=

#------------------------------------------------------------------------------
# LOCALFLAGS is intended for program specific modifications to the
# Fortran build process and may be modified by the program's local makefile
#------------------------------------------------------------------------------
LOCALFLAGS=

#------------------------------------------------------------------------------
# Availability and method of delivery of math and optional libraries
#------------------------------------------------------------------------------
USE_BLASLIB=$(VENDOR_SUPPLIED)
USE_LAPACKLIB=$(VENDOR_SUPPLIED)
USE_LMODLIB=$(LMOD_UNAVAILABLE)

#------------------------------------------------------------------------------
# C compiler
#------------------------------------------------------------------------------
CC= icc
CPLUSPLUS=icpc
CFLAGS= -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE -O2
CPPFLAGS= $(AMBERBUILDFLAGS)

#------------------------------------------------------------------------------
# Fortran preprocessing and compiler.
# FPPFLAGS holds the main Fortran options, such as whether MPI is used.
#------------------------------------------------------------------------------
FPPFLAGS= -P -DMPI  -DMKL $(AMBERBUILDFLAGS)
FPP= cpp -traditional $(FPPFLAGS)
FC= ifort
FFLAGS=  -w95 -ftz   -O2 $(LOCALFLAGS) $(AMBERBUILDFLAGS)
FOPTFLAGS=  -mtune=itanium2-p9000 -mcpu=itanium2-p9000 -w95 -ftz   -O3 -IPF_fma -IPF_fp_relaxed -ip $(LOCALFLAGS) $(AMBERBUILDFLAGS)
FREEFORMAT_FLAG= -FR

#------------------------------------------------------------------------------
# Loader:
#------------------------------------------------------------------------------
LOAD= ifort $(LOCALFLAGS) $(AMBERBUILDFLAGS)
LOADCC= icc $(LOCALFLAGS) $(AMBERBUILDFLAGS)
LOADLIB= -lmpi /disk1/chem/intel/mkl/10.0.1.014/lib/64/libmkl_intel_lp64.a /disk1/chem/intel/mkl/10.0.1.014/lib/64/libmkl_intel_thread.a /disk1/chem/intel/mkl/10.0.1.014/lib/64/libmkl_core.a /disk1/chem/intel/mkl/10.0.1.014/lib/64/libmkl_intel_thread.a /disk1/chem/intel/mkl/10.0.1.014/lib/64/libmkl_core.a /disk1/chem/intel/mkl/10.0.1.014/lib/64/libmkl_intel_thread.a /disk1/chem/intel/mkl/10.0.1.014/lib/64/libmkl_core.a -liomp5 -ldl
LM= -lm
LOADPTRAJ= ifort -nofor_main $(LOCALFLAGS) $(AMBERBUILDFLAGS)
XHOME= /usr/X11R6
XLIBS= -L/usr/X11R6/lib

#------------------------------------------------------------------------------
#  Other stuff:
#------------------------------------------------------------------------------
.SUFFIXES:  .f90
EMPTY=
AR=ar rv $(EMPTY)
M4=m4
RANLIB=ranlib
SFX=
NETCDF=
NETCDFLIB=
MODULEDIR=-I
MAKEDEPEND=$(AMBER_SRC)/../bin/amber_makedepend
SLKO=skipDFTB

#  default rules for Fortran and C compilation:

.f.o:   $<
	$(FPP) $< > _$<
	$(FC) -c $(FFLAGS) -o $@ _$<

.c.o:
	$(CC) -c $(CFLAGS) $(CPPFLAGS) -o $@ $<

